/* --------------------------------------------------------------
  Config.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Config Class
 *
 * This class is serving as a configuration registry where users can only get the values and not 
 * change them. This is done for data integrity and stability reasons, so a global StyleEdit. The 
 * Config object will be instantiated once during the initialization of the application.
 */
export default class Config {
	/**
	 * Class Constructor 
	 * 
	 * @param {Object} config Contains the key-value pairs of configuration.
	 */
	constructor(config) {
		/**
		 * @type {Object}
		 */
		this.config = config;
	}
	
	/**
	 * Get a config value by key.
	 *
	 * @param {String} key The key of the value to be returned.
	 *
	 * @return {*} Returns the value.
	 */
	get(key) {
		StyleEdit.Validator.isString(key);
		
		const value = this.config[key];
		
		if (value === undefined) {
			throw new Error('StyleEdit: The requested value does not exist the config object: "' + key + '"');
		}
		
		return value;
	}
}
